<?php
include("config/db.php");

echo "<h2>🔧 Fixing Wallet Calculation Issues</h2>";

// Add columns if not exist
mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS recharge_amount DECIMAL(10,2) DEFAULT 0.00");
mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS winning_amount DECIMAL(10,2) DEFAULT 0.00");

// Get all users
$users = mysqli_query($conn, "SELECT * FROM users");

echo "<h3>Checking and fixing each user's balance:</h3>";

while($user = mysqli_fetch_assoc($users)) {
    $user_id = $user['id'];
    
    echo "<div style='background:#f8f9fa;padding:15px;margin:10px 0;border-radius:8px;border-left:4px solid #007bff;'>";
    echo "<h4>👤 {$user['name']} (ID: $user_id)</h4>";
    
    // Current values
    echo "<p><strong>Current Values:</strong></p>";
    echo "<p>💰 Wallet: ₹" . number_format($user['wallet'], 2) . "</p>";
    echo "<p>🎯 Winning Amount: ₹" . number_format($user['winning_amount'], 2) . "</p>";
    echo "<p>💳 Recharge Amount: ₹" . number_format($user['recharge_amount'], 2) . "</p>";
    
    // Calculate correct values
    
    // 1. Total winnings from bets
    $winnings = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT COALESCE(SUM(win_amount), 0) as total_winnings 
        FROM bets 
        WHERE user_id = $user_id AND status = 'win'
    "));
    $correct_winning_amount = $winnings['total_winnings'];
    
    // 2. Total approved recharges
    $recharges = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT COALESCE(SUM(amount), 0) as total_recharges 
        FROM recharge_requests 
        WHERE user_id = $user_id AND status = 'approved'
    "));
    $correct_recharge_amount = $recharges['total_recharges'];
    
    // 3. Total pending withdrawals
    $withdrawals = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT COALESCE(SUM(amount), 0) as total_withdrawals 
        FROM withdrawal_requests 
        WHERE user_id = $user_id AND status = 'pending'
    "));
    $pending_withdrawals = $withdrawals['total_withdrawals'];
    
    // 4. Calculate correct wallet balance
    $correct_wallet = $correct_recharge_amount + $correct_winning_amount - $pending_withdrawals;
    
    echo "<p><strong>Calculated Correct Values:</strong></p>";
    echo "<p>🎯 Correct Winning Amount: ₹" . number_format($correct_winning_amount, 2) . "</p>";
    echo "<p>💳 Correct Recharge Amount: ₹" . number_format($correct_recharge_amount, 2) . "</p>";
    echo "<p>⏳ Pending Withdrawals: ₹" . number_format($pending_withdrawals, 2) . "</p>";
    echo "<p>💰 Correct Wallet: ₹" . number_format($correct_wallet, 2) . "</p>";
    
    // Check if correction is needed
    $needs_correction = (
        abs($user['wallet'] - $correct_wallet) > 0.01 ||
        abs($user['winning_amount'] - $correct_winning_amount) > 0.01 ||
        abs($user['recharge_amount'] - $correct_recharge_amount) > 0.01
    );
    
    if($needs_correction) {
        echo "<p style='color:#e74c3c;'><strong>❌ Correction Needed!</strong></p>";
        
        // Update with correct values
        mysqli_query($conn, "
            UPDATE users 
            SET wallet = $correct_wallet,
                winning_amount = $correct_winning_amount,
                recharge_amount = $correct_recharge_amount
            WHERE id = $user_id
        ");
        
        echo "<p style='color:#27ae60;'><strong>✅ Fixed!</strong></p>";
    } else {
        echo "<p style='color:#27ae60;'><strong>✅ Already Correct</strong></p>";
    }
    
    echo "</div>";
}

echo "<br><h3>✅ All user balances have been checked and corrected!</h3>";

// Show final summary
$summary = mysqli_query($conn, "
    SELECT 
        COUNT(*) as total_users,
        SUM(wallet) as total_wallet,
        SUM(winning_amount) as total_winnings,
        SUM(recharge_amount) as total_recharge
    FROM users
");

$stats = mysqli_fetch_assoc($summary);

echo "<div style='background:#e8f5e8;padding:20px;border-radius:10px;margin:20px 0;border:2px solid #28a745;'>";
echo "<h3>📊 Final Summary:</h3>";
echo "<p><strong>Total Users:</strong> " . $stats['total_users'] . "</p>";
echo "<p><strong>Total Wallet Amount:</strong> ₹" . number_format($stats['total_wallet'], 2) . "</p>";
echo "<p><strong>Total Winning Amount:</strong> ₹" . number_format($stats['total_winnings'], 2) . "</p>";
echo "<p><strong>Total Recharge Amount:</strong> ₹" . number_format($stats['total_recharge'], 2) . "</p>";
echo "</div>";

echo "<br><a href='user/withdraw.php' target='_blank' style='background:#28a745;color:white;padding:10px 15px;text-decoration:none;border-radius:5px;'>🏧 Test Withdrawal Page</a>";
?>