<?php
include("config/db.php");

echo "<h2>🔧 Database Fix</h2>";

// Check current games table structure
echo "<h3>Current Games Table Structure:</h3>";
$structure = mysqli_query($conn, "DESCRIBE games");
if($structure){
    echo "<table border='1' style='border-collapse:collapse'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
    while($col = mysqli_fetch_assoc($structure)){
        echo "<tr>";
        echo "<td>{$col['Field']}</td>";
        echo "<td>{$col['Type']}</td>";
        echo "<td>{$col['Null']}</td>";
        echo "<td>{$col['Key']}</td>";
        echo "<td>{$col['Default']}</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>❌ Could not describe games table</p>";
}

// Check if winning_color column exists
$check_column = mysqli_query($conn, "SHOW COLUMNS FROM games LIKE 'winning_color'");
$has_winning_color = mysqli_num_rows($check_column) > 0;

echo "<h3>Winning Color Column Status:</h3>";
if($has_winning_color){
    echo "<p>✅ winning_color column exists</p>";
} else {
    echo "<p>❌ winning_color column missing</p>";
    
    // Add the column
    echo "<h4>Adding winning_color column...</h4>";
    $add_column = mysqli_query($conn, "ALTER TABLE games ADD COLUMN winning_color VARCHAR(20) NULL");
    if($add_column){
        echo "<p>✅ Successfully added winning_color column</p>";
    } else {
        echo "<p>❌ Failed to add column: " . mysqli_error($conn) . "</p>";
    }
}

// Check if completed_at column exists
$check_completed = mysqli_query($conn, "SHOW COLUMNS FROM games LIKE 'completed_at'");
$has_completed_at = mysqli_num_rows($check_completed) > 0;

echo "<h3>Completed At Column Status:</h3>";
if($has_completed_at){
    echo "<p>✅ completed_at column exists</p>";
} else {
    echo "<p>❌ completed_at column missing</p>";
    
    // Add the column
    echo "<h4>Adding completed_at column...</h4>";
    $add_completed = mysqli_query($conn, "ALTER TABLE games ADD COLUMN completed_at TIMESTAMP NULL");
    if($add_completed){
        echo "<p>✅ Successfully added completed_at column</p>";
    } else {
        echo "<p>❌ Failed to add column: " . mysqli_error($conn) . "</p>";
    }
}

// Show final structure
echo "<h3>Final Games Table Structure:</h3>";
$final_structure = mysqli_query($conn, "DESCRIBE games");
if($final_structure){
    echo "<table border='1' style='border-collapse:collapse'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
    while($col = mysqli_fetch_assoc($final_structure)){
        echo "<tr>";
        echo "<td>{$col['Field']}</td>";
        echo "<td>{$col['Type']}</td>";
        echo "<td>{$col['Null']}</td>";
        echo "<td>{$col['Key']}</td>";
        echo "<td>{$col['Default']}</td>";
        echo "</tr>";
    }
    echo "</table>";
}

echo "<hr>";
echo "<h3>✅ Database Fix Complete!</h3>";
echo "<p><a href='user/dashboard.php'>🎮 Test Game Now</a></p>";
?>