<?php
include("config/db.php");

// Check if user is logged in
if(!isset($_SESSION['user_id'])){
    die("Please login first");
}

$user_id = $_SESSION['user_id'];

echo "<h2>🔍 Debug Bets for User ID: $user_id</h2>";

// Get current running game
$current_game = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM games WHERE status='running' ORDER BY id DESC LIMIT 1"));
if($current_game){
    echo "<h3>Current Game: #{$current_game['id']}</h3>";
    
    // Get user's bets for current game
    $bets = mysqli_query($conn, "
        SELECT * FROM bets 
        WHERE user_id=$user_id AND game_id={$current_game['id']} 
        ORDER BY created_at DESC
    ");
    
    if(mysqli_num_rows($bets) > 0){
        echo "<table border='1' style='border-collapse:collapse; width:100%'>";
        echo "<tr><th>ID</th><th>Color</th><th>Amount</th><th>Status</th><th>Win Amount</th><th>Created</th></tr>";
        
        while($bet = mysqli_fetch_assoc($bets)){
            echo "<tr>";
            echo "<td>{$bet['id']}</td>";
            echo "<td style='background:{$bet['color']};color:white;padding:5px'>{$bet['color']}</td>";
            echo "<td>₹{$bet['amount']}</td>";
            echo "<td>{$bet['status']}</td>";
            echo "<td>₹{$bet['win_amount']}</td>";
            echo "<td>{$bet['created_at']}</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p>No bets found for current game</p>";
    }
}

// Get recent completed games
echo "<h3>Recent Completed Games</h3>";
$recent_games = mysqli_query($conn, "
    SELECT g.*, COUNT(b.id) as bet_count, SUM(b.amount) as total_bet, SUM(b.win_amount) as total_win
    FROM games g 
    LEFT JOIN bets b ON g.id = b.game_id AND b.user_id = $user_id
    WHERE g.status = 'completed' 
    GROUP BY g.id 
    ORDER BY g.id DESC 
    LIMIT 5
");

if(mysqli_num_rows($recent_games) > 0){
    echo "<table border='1' style='border-collapse:collapse; width:100%'>";
    echo "<tr><th>Game ID</th><th>Winner Color</th><th>Your Bets</th><th>Total Bet</th><th>Total Win</th><th>Completed</th></tr>";
    
    while($game = mysqli_fetch_assoc($recent_games)){
        echo "<tr>";
        echo "<td>#{$game['id']}</td>";
        echo "<td style='background:{$game['winning_color']};color:white;padding:5px'>{$game['winning_color']}</td>";
        echo "<td>{$game['bet_count']}</td>";
        echo "<td>₹{$game['total_bet']}</td>";
        echo "<td>₹{$game['total_win']}</td>";
        echo "<td>{$game['completed_at']}</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>No completed games found</p>";
}

// User wallet info
$user = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM users WHERE id=$user_id"));
echo "<h3>User Info</h3>";
echo "<p><strong>Name:</strong> {$user['name']}</p>";
echo "<p><strong>Email:</strong> {$user['email']}</p>";
echo "<p><strong>Wallet:</strong> ₹{$user['wallet']}</p>";

echo "<hr>";
echo "<h3>🧪 Test Winning Logic</h3>";
if($current_game){
    echo "<p>Test with current game #{$current_game['id']}:</p>";
    echo "<button onclick='testWin(\"red\")' style='background:red;color:white;padding:5px 10px;margin:2px;border:none;border-radius:3px'>Test Red Win</button>";
    echo "<button onclick='testWin(\"green\")' style='background:green;color:white;padding:5px 10px;margin:2px;border:none;border-radius:3px'>Test Green Win</button>";
    echo "<button onclick='testWin(\"blue\")' style='background:blue;color:white;padding:5px 10px;margin:2px;border:none;border-radius:3px'>Test Blue Win</button>";
    echo "<button onclick='testWin()' style='background:gray;color:white;padding:5px 10px;margin:2px;border:none;border-radius:3px'>Test Random</button>";
    echo "<div id='testResult' style='margin-top:10px;padding:10px;background:#f0f0f0;border-radius:5px;display:none'></div>";
    
    echo "<script>
    function testWin(color = null) {
        fetch('dashboard.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: 'action=test_win&game_id={$current_game['id']}' + (color ? '&force_winner=' + color : '')
        })
        .then(r => r.json())
        .then(d => {
            document.getElementById('testResult').style.display = 'block';
            document.getElementById('testResult').innerHTML = 
                '<h4>Test Result:</h4>' +
                '<p><strong>Winner:</strong> ' + d.winner + '</p>' +
                '<p><strong>Win Amount:</strong> ₹' + d.win_amount + '</p>' +
                '<p><strong>Total Bet:</strong> ₹' + d.total_bet + '</p>' +
                '<p><strong>Bet Details:</strong></p>' +
                '<pre>' + JSON.stringify(d.bet_details, null, 2) + '</pre>';
        });
    }
    </script>";
}

echo "<hr>";
echo "<p><a href='user/dashboard.php'>🎮 Back to Game</a></p>";
?>