<?php
// ✅ USER SESSION - PERMANENT COOKIE BASED AUTHENTICATION
ini_set('session.gc_maxlifetime', 86400 * 365); // 1 year
ini_set('session.cookie_lifetime', 86400 * 365); // 1 year

session_name("USERSESSID");
session_set_cookie_params([
    'lifetime' => 86400 * 365, // 1 year
    'path' => '/',
    'secure' => false,
    'httponly' => true,
    'samesite' => 'Lax'
]);

session_start();

/* 🍪 PERMANENT COOKIE AUTHENTICATION */
// Check if user_id cookie exists but session doesn't
if(!isset($_SESSION['user_id']) && isset($_COOKIE['user_id_permanent'])) {
    // Restore session from cookie
    $_SESSION['user_id'] = (int)$_COOKIE['user_id_permanent'];
    $_SESSION['user_name'] = $_COOKIE['user_name_permanent'] ?? '';
}

// If session exists but cookie doesn't, create cookie
if(isset($_SESSION['user_id']) && !isset($_COOKIE['user_id_permanent'])) {
    setcookie('user_id_permanent', $_SESSION['user_id'], time() + (86400 * 365), '/');
    if(isset($_SESSION['user_name'])) {
        setcookie('user_name_permanent', $_SESSION['user_name'], time() + (86400 * 365), '/');
    }
}

/* 🔒 Cache control */
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
?>
