-- Color Game Database Structure
-- Run this complete SQL file in phpMyAdmin

-- Create database (if not exists)
CREATE DATABASE IF NOT EXISTS color_game;
USE color_game;

-- 1. Users table
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    wallet DECIMAL(10,2) DEFAULT 0.00,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- 2. Games table (with all required columns)
CREATE TABLE IF NOT EXISTS games (
    id INT AUTO_INCREMENT PRIMARY KEY,
    status ENUM('running', 'completed') DEFAULT 'running',
    winning_color VARCHAR(20) NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    completed_at TIMESTAMP NULL
);

-- 3. Bets table
CREATE TABLE IF NOT EXISTS bets (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    game_id INT NOT NULL,
    color VARCHAR(20) NOT NULL,
    amount DECIMAL(10,2) NOT NULL,
    status ENUM('pending', 'win', 'loss') DEFAULT 'pending',
    win_amount DECIMAL(10,2) DEFAULT 0.00,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (game_id) REFERENCES games(id) ON DELETE CASCADE
);

-- 4. Game history table (for admin panel)
CREATE TABLE IF NOT EXISTS game_history (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    bet_amount DECIMAL(10,2) NOT NULL,
    user_color VARCHAR(20) NOT NULL,
    result_color VARCHAR(20) NOT NULL,
    result ENUM('Win', 'Lose') NOT NULL,
    bet_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

-- 5. Admins table
CREATE TABLE IF NOT EXISTS admins (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Insert default admin
INSERT IGNORE INTO admins (username, password) VALUES ('admin', 'admin123');

-- Insert initial running game
INSERT IGNORE INTO games (status, created_at) VALUES ('running', NOW());

-- Insert test user (optional)
INSERT IGNORE INTO users (name, email, password, wallet) VALUES 
('Test User', 'test@example.com', 'test123', 1000.00);

-- Show all tables
SHOW TABLES;

-- Show games table structure
DESCRIBE games;