<?php
include("config/db.php");

// Auto Game Processor - Runs games automatically in background
// This should be called every minute via cron job or can be called manually

echo "<h2>🎮 Auto Game Processor</h2>";
echo "<p>Processing games automatically...</p>";

// Get current running game
$running_game = mysqli_query($conn, "
    SELECT id, created_at 
    FROM games 
    WHERE status='running' 
    ORDER BY id DESC 
    LIMIT 1
");

if($running_game && mysqli_num_rows($running_game) > 0) {
    $game = mysqli_fetch_assoc($running_game);
    $game_id = $game['id'];
    $created_time = strtotime($game['created_at']);
    $current_time = time();
    $elapsed_seconds = $current_time - $created_time;
    
    echo "<p>🎯 Found running game ID: $game_id</p>";
    echo "<p>⏰ Game started: " . date('H:i:s', $created_time) . "</p>";
    echo "<p>🕐 Current time: " . date('H:i:s', $current_time) . "</p>";
    echo "<p>⏱️ Elapsed time: $elapsed_seconds seconds</p>";
    
    // Check if game should be completed (after 30 seconds)
    if($elapsed_seconds >= 30) {
        echo "<p>🚨 Game time expired! Processing results...</p>";
        
        // Generate random winner
        $colors = ['red', 'green', 'yellow', 'blue', 'purple', 'orange', 'pink', 'cyan'];
        $winner = $colors[array_rand($colors)];
        
        echo "<p>🎲 Generated winner: <strong>$winner</strong></p>";
        
        // Get all pending bets for this game
        $bets_result = mysqli_query($conn, "
            SELECT * FROM bets 
            WHERE game_id=$game_id AND status='pending'
        ");
        
        $total_bets = mysqli_num_rows($bets_result);
        echo "<p>📊 Processing $total_bets pending bets...</p>";
        
        $processed_users = [];
        
        if($total_bets > 0) {
            while($bet = mysqli_fetch_assoc($bets_result)) {
                $user_id = $bet['user_id'];
                $bet_color = strtolower(trim($bet['color']));
                $bet_amount = $bet['amount'];
                $winner_color = strtolower(trim($winner));
                
                if($bet_color === $winner_color) {
                    // WIN - 2x payout
                    $win_amount = $bet_amount * 2;
                    
                    // Add to wallet
                    mysqli_query($conn, "UPDATE users SET wallet = wallet + $win_amount WHERE id = $user_id");
                    
                    // Update bet to win
                    mysqli_query($conn, "UPDATE bets SET status='win', win_amount=$win_amount WHERE id={$bet['id']}");
                    
                    echo "<p>✅ User $user_id: WON ₹$win_amount (bet: $bet_color)</p>";
                    
                    if(!in_array($user_id, $processed_users)) {
                        $processed_users[] = $user_id;
                    }
                } else {
                    // LOSS
                    mysqli_query($conn, "UPDATE bets SET status='loss', win_amount=0 WHERE id={$bet['id']}");
                    echo "<p>❌ User $user_id: LOST ₹$bet_amount (bet: $bet_color)</p>";
                }
            }
        }
        
        // Mark game as completed with winner
        $winner_escaped = mysqli_real_escape_string($conn, $winner);
        $complete_result = mysqli_query($conn, "
            UPDATE games 
            SET status='completed', winning_color='$winner_escaped', completed_at=NOW() 
            WHERE id=$game_id
        ");
        
        if($complete_result) {
            echo "<p>🏁 Game $game_id completed successfully!</p>";
            echo "<p>🏆 Winner: <strong>$winner</strong></p>";
            echo "<p>👥 Processed users: " . count($processed_users) . "</p>";
        } else {
            echo "<p>❌ Failed to complete game: " . mysqli_error($conn) . "</p>";
        }
        
        // Create new running game
        $new_game = mysqli_query($conn, "INSERT INTO games(status,created_at) VALUES('running',NOW())");
        if($new_game) {
            $new_game_id = mysqli_insert_id($conn);
            echo "<p>🆕 New game started: ID $new_game_id</p>";
        }
        
    } else {
        $remaining = 30 - $elapsed_seconds;
        echo "<p>⏳ Game still running... $remaining seconds remaining</p>";
    }
    
} else {
    echo "<p>🆕 No running game found, creating new one...</p>";
    
    // Create new game
    $new_game = mysqli_query($conn, "INSERT INTO games(status,created_at) VALUES('running',NOW())");
    if($new_game) {
        $new_game_id = mysqli_insert_id($conn);
        echo "<p>✅ New game created: ID $new_game_id</p>";
    } else {
        echo "<p>❌ Failed to create new game: " . mysqli_error($conn) . "</p>";
    }
}

echo "<hr>";
echo "<p><a href='user/dashboard.php'>📊 View Dashboard</a></p>";
echo "<p><a href='user/game.php'>🎮 Play Game</a></p>";
echo "<p><strong>⚠️ Important:</strong> This script should run automatically every minute for best results.</p>";
?>