<?php
include("../config/db.php");
include("../config/session_admin.php");


// ❌ yahan session_start() mat likhna (db.php me already hai)

// 🔐 Admin login check
if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

/* ================= DATE LOGIC (TODAY DEFAULT) ================= */
if(isset($_GET['date']) && $_GET['date'] != ""){
    $date = mysqli_real_escape_string($conn, $_GET['date']);
}else{
    $date = date("Y-m-d"); // default today
}

/* ================= APPROVE / REJECT ================= */
if(isset($_GET['action'], $_GET['id'])){
    $id = (int)$_GET['id'];
    $action = $_GET['action'];

    // sirf pending request uthao
    $reqRes = mysqli_query($conn,"
        SELECT * FROM recharge_requests 
        WHERE id=$id AND status='pending'
    ");

    if($reqRes && mysqli_num_rows($reqRes) == 1){
        $req = mysqli_fetch_assoc($reqRes);

        if($action == 'approve'){
            // Add recharge_amount column if not exists
            mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS recharge_amount DECIMAL(10,2) DEFAULT 0.00");
            
            // Add to both wallet and recharge_amount
            mysqli_query($conn,"
                UPDATE users 
                SET wallet = wallet + {$req['amount']},
                    recharge_amount = recharge_amount + {$req['amount']}
                WHERE id = {$req['user_id']}
            ");

            // status approved
            mysqli_query($conn,"
                UPDATE recharge_requests 
                SET status='approved'
                WHERE id=$id
            ");
        }

        if($action == 'reject'){
            mysqli_query($conn,"
                UPDATE recharge_requests 
                SET status='rejected'
                WHERE id=$id
            ");
        }
    }

    // same date ke sath reload
    header("Location: recharge_requests.php?date=".$date);
    exit;
}

/* ================= PENDING COUNT ================= */
$pending_count = 0;
$pc = mysqli_query($conn,"
    SELECT COUNT(*) AS total 
    FROM recharge_requests 
    WHERE status='pending'
");
if($pc){
    $pending_count = mysqli_fetch_assoc($pc)['total'];
}

/* ================= FETCH REQUESTS (DATE WISE) ================= */
$requests = mysqli_query($conn,"
    SELECT r.*, u.email
    FROM recharge_requests r
    JOIN users u ON u.id = r.user_id
    WHERE r.created_at BETWEEN '$date 00:00:00' AND '$date 23:59:59'
    ORDER BY r.id DESC
");
?>
<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="mobile-responsive.css">
<title>Recharge Requests</title>
<style>
body{font-family:Arial;background:#f4f6f8}
.box{
    width:1000px;
    margin:30px auto;
    background:#fff;
    padding:20px;
    border-radius:8px;
    box-shadow:0 2px 6px rgba(0,0,0,.2);
}
table{
    width:100%;
    border-collapse:collapse;
    margin-top:15px;
}
th,td{
    border:1px solid #ccc;
    padding:8px;
    text-align:center;
}
th{background:#eee}
.badge{
    background:red;
    color:#fff;
    padding:3px 8px;
    border-radius:12px;
    font-size:12px;
}
.approve{color:green;font-weight:bold}
.reject{color:red;font-weight:bold}
a.btn{
    padding:5px 10px;
    text-decoration:none;
    border-radius:4px;
    color:#fff;
}
.btn-approve{background:#28a745}
.btn-reject{background:#dc3545}
.top{
    display:flex;
    justify-content:space-between;
    align-items:center;
}
</style>
</head>
<body>

<div class="box">

<div class="top">
    <h2>
        💳 Recharge Requests
        <?php if($pending_count > 0){ ?>
            <span class="badge">🔔 <?php echo $pending_count; ?></span>
        <?php } ?>
    </h2>

    <!-- DATE FILTER -->
    <form method="get">
        <input type="date" name="date" value="<?php echo $date; ?>">
        <button type="submit">Search</button>
    </form>
</div>

<table class="recharge-table">
<tr>
    <th>ID</th>
    <th>User (Email)</th>
    <th>Amount</th>
    <th>Method</th>
    <th>Txn ID</th>
    <th>Status</th>
    <th>Date & Time</th>
    <th>Action</th>
</tr>

<?php if(!$requests || mysqli_num_rows($requests) == 0){ ?>
<tr>
    <td colspan="8">No recharge requests found</td>
</tr>
<?php } ?>

<?php if($requests){ while($r = mysqli_fetch_assoc($requests)){ ?>
<tr>
    <td><?php echo $r['id']; ?></td>
    <td><?php echo $r['email']; ?></td>
    <td>₹ <?php echo $r['amount']; ?></td>
    <td><?php echo $r['method']; ?></td>
    <td><?php echo $r['txn_id']; ?></td>
    <td>
        <?php
        if($r['status']=='pending') echo "<span class='badge'>Pending</span>";
        if($r['status']=='approved') echo "<span class='approve'>Approved</span>";
        if($r['status']=='rejected') echo "<span class='reject'>Rejected</span>";
        ?>
    </td>
    <td><?php echo date("d-m-Y h:i A", strtotime($r['created_at'])); ?></td>
    <td>
        <?php if($r['status']=='pending'){ ?>
            <a class="btn btn-approve"
               href="?action=approve&id=<?php echo $r['id']; ?>&date=<?php echo $date; ?>">
               Approve
            </a>
            <a class="btn btn-reject"
               href="?action=reject&id=<?php echo $r['id']; ?>&date=<?php echo $date; ?>">
               Reject
            </a>
        <?php }else{ echo "-"; } ?>
    </td>
</tr>
<?php } } ?>
</table>

<br>
<a href="dashboard.php?date=<?php echo $date; ?>">⬅ Back to Dashboard</a>

</div>

</body>
</html>
