<?php
include("config/db.php");

if(!isset($_SESSION['user_id'])){
    die("Please login first");
}

$user_id = $_SESSION['user_id'];

// Add money to wallet for testing
if(isset($_POST['add_money'])){
    $amount = (int)$_POST['amount'];
    if($amount > 0){
        mysqli_query($conn, "UPDATE users SET wallet = wallet + $amount WHERE id = $user_id");
        echo "<p style='color:green'>✅ Added ₹$amount to wallet</p>";
    }
}

// Get current wallet
$user = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM users WHERE id=$user_id"));

echo "<h2>💰 Wallet Check - User #{$user_id}</h2>";
echo "<p><strong>Name:</strong> {$user['name']}</p>";
echo "<p><strong>Email:</strong> {$user['email']}</p>";
echo "<p><strong>Current Wallet:</strong> ₹{$user['wallet']}</p>";

// Add money form
echo "<h3>Add Money (for testing)</h3>";
echo "<form method='post'>";
echo "<select name='amount'>";
echo "<option value='100'>₹100</option>";
echo "<option value='500'>₹500</option>";
echo "<option value='1000'>₹1000</option>";
echo "</select>";
echo "<button type='submit' name='add_money'>Add Money</button>";
echo "</form>";

// Recent transactions
echo "<h3>Recent Bets</h3>";
$recent_bets = mysqli_query($conn, "
    SELECT b.*, g.winning_color, g.completed_at 
    FROM bets b 
    LEFT JOIN games g ON b.game_id = g.id 
    WHERE b.user_id = $user_id 
    ORDER BY b.created_at DESC 
    LIMIT 10
");

if(mysqli_num_rows($recent_bets) > 0){
    echo "<table border='1' style='border-collapse:collapse; width:100%'>";
    echo "<tr><th>Game</th><th>Color</th><th>Amount</th><th>Status</th><th>Win Amount</th><th>Winner</th><th>Date</th></tr>";
    
    while($bet = mysqli_fetch_assoc($recent_bets)){
        $bg_color = $bet['status'] == 'win' ? '#d4edda' : ($bet['status'] == 'loss' ? '#f8d7da' : '#fff3cd');
        echo "<tr style='background:$bg_color'>";
        echo "<td>#{$bet['game_id']}</td>";
        echo "<td style='background:{$bet['color']};color:white;padding:5px'>{$bet['color']}</td>";
        echo "<td>₹{$bet['amount']}</td>";
        echo "<td>{$bet['status']}</td>";
        echo "<td>₹{$bet['win_amount']}</td>";
        echo "<td>" . ($bet['winning_color'] ? $bet['winning_color'] : 'N/A') . "</td>";
        echo "<td>{$bet['created_at']}</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>No bets found</p>";
}

echo "<hr>";
echo "<p><a href='user/dashboard.php'>🎮 Back to Game</a></p>";
echo "<p><a href='simple_test.php'>🧪 Simple Test</a></p>";
?>