<?php
$page_title = "Wallet History";
include("includes/header.php");

// Get selected date (default to today)
$selected_date = isset($_GET['date']) && !empty($_GET['date']) ? $_GET['date'] : date('Y-m-d');

// Validate date format
if(!preg_match('/^\d{4}-\d{2}-\d{2}$/', $selected_date)) {
    $selected_date = date('Y-m-d');
}

// Date range for queries
$date_start = $selected_date . ' 00:00:00';
$date_end = $selected_date . ' 23:59:59';

// Get recharge history for selected date
$recharge_query = mysqli_query($conn, "
    SELECT amount, method, status, created_at 
    FROM recharge_requests 
    WHERE user_id = $user_id 
      AND created_at BETWEEN '$date_start' AND '$date_end'
    ORDER BY created_at DESC
");

$recharge_data = [];
$total_recharge = 0;
$approved_recharge = 0;

if($recharge_query) {
    while($row = mysqli_fetch_assoc($recharge_query)) {
        $recharge_data[] = $row;
        if($row['status'] == 'approved') {
            $approved_recharge += $row['amount'];
        }
        $total_recharge += $row['amount'];
    }
}

// Get betting history for selected date (grouped by game)
$betting_query = mysqli_query($conn, "
    SELECT 
        MIN(b.created_at) as bet_time,
        SUM(b.amount) as total_bet_amount,
        SUM(CASE WHEN b.status = 'win' THEN b.win_amount ELSE 0 END) as total_win_amount,
        COUNT(*) as bet_count,
        MAX(CASE WHEN b.status = 'win' THEN 'win' 
                 WHEN b.status = 'loss' THEN 'loss' 
                 ELSE 'pending' END) as game_result,
        g.winning_color
    FROM bets b
    LEFT JOIN games g ON b.game_id = g.id
    WHERE b.user_id = $user_id 
      AND b.created_at BETWEEN '$date_start' AND '$date_end'
    GROUP BY b.game_id, g.winning_color
    ORDER BY MIN(b.created_at) DESC
");

$betting_data = [];
$total_bets = 0;
$total_bet_amount = 0;
$total_winnings = 0;
$win_count = 0;

if($betting_query) {
    while($row = mysqli_fetch_assoc($betting_query)) {
        $betting_data[] = $row;
        $total_bet_amount += $row['total_bet_amount'];
        $total_winnings += $row['total_win_amount'];
        if($row['total_win_amount'] > 0) {
            $win_count++;
        }
    }
    $total_bets = count($betting_data);
}

// Get withdrawal history for selected date
$withdrawal_query = mysqli_query($conn, "
    SELECT amount, method, status, created_at 
    FROM withdrawal_requests 
    WHERE user_id = $user_id 
      AND created_at BETWEEN '$date_start' AND '$date_end'
    ORDER BY created_at DESC
");

$withdrawal_data = [];
$total_withdrawal = 0;
$approved_withdrawal = 0;

if($withdrawal_query) {
    while($row = mysqli_fetch_assoc($withdrawal_query)) {
        $withdrawal_data[] = $row;
        if($row['status'] == 'approved') {
            $approved_withdrawal += $row['amount'];
        }
        $total_withdrawal += $row['amount'];
    }
}
?>

<div class="container">
    <!-- Date Filter -->
    <div class="content-box">
        <h2 class="section-title">📅 Select Date</h2>
        <form method="GET" style="display:flex;gap:15px;align-items:center;flex-wrap:wrap;">
            <input type="date" name="date" value="<?= $selected_date ?>" class="form-input" style="width:auto;min-width:200px;">
            <button type="submit" class="btn">📊 View History</button>
            <a href="?date=<?= date('Y-m-d') ?>" class="btn btn-secondary">📅 Today</a>
        </form>
    </div>

    <!-- Summary Cards -->
    <div class="content-box">
        <h2 class="section-title">📊 Summary for <?= date('M j, Y', strtotime($selected_date)) ?></h2>
        
        <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:20px;margin-bottom:30px;">
            <!-- Recharge Summary -->
            <div style="padding:20px;background:rgba(52,152,219,0.2);border-radius:15px;border:1px solid #3498db;text-align:center;">
                <div style="font-size:28px;font-weight:700;color:#3498db;">
                    <?= count($recharge_data) ?>
                </div>
                <p style="color:#3498db;font-weight:600;margin:5px 0;">Recharge Requests</p>
                <small style="opacity:0.8;">₹<?= number_format($approved_recharge, 2) ?> approved</small>
            </div>

            <!-- Betting Summary -->
            <div style="padding:20px;background:rgba(155,89,182,0.2);border-radius:15px;border:1px solid #9b59b6;text-align:center;">
                <div style="font-size:28px;font-weight:700;color:#9b59b6;">
                    <?= $total_bets ?>
                </div>
                <p style="color:#9b59b6;font-weight:600;margin:5px 0;">Games Played</p>
                <small style="opacity:0.8;">₹<?= number_format($total_bet_amount, 2) ?> total bet</small>
            </div>

            <!-- Winning Summary -->
            <div style="padding:20px;background:rgba(39,174,96,0.2);border-radius:15px;border:1px solid #27ae60;text-align:center;">
                <div style="font-size:28px;font-weight:700;color:#27ae60;">
                    <?= $win_count ?>
                </div>
                <p style="color:#27ae60;font-weight:600;margin:5px 0;">Games Won</p>
                <small style="opacity:0.8;">₹<?= number_format($total_winnings, 2) ?> won</small>
            </div>

            <!-- Withdrawal Summary -->
            <div style="padding:20px;background:rgba(231,76,60,0.2);border-radius:15px;border:1px solid #e74c3c;text-align:center;">
                <div style="font-size:28px;font-weight:700;color:#e74c3c;">
                    <?= count($withdrawal_data) ?>
                </div>
                <p style="color:#e74c3c;font-weight:600;margin:5px 0;">Withdrawals</p>
                <small style="opacity:0.8;">₹<?= number_format($approved_withdrawal, 2) ?> approved</small>
            </div>
        </div>

        <!-- Net Summary -->
        <div style="padding:20px;background:rgba(255,193,7,0.2);border-radius:15px;border:1px solid #ffc107;text-align:center;">
            <h3 style="color:#ffc107;margin-bottom:15px;">💰 Net Summary</h3>
            <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(150px,1fr));gap:15px;">
                <div>
                    <strong style="color:#27ae60;">+₹<?= number_format($approved_recharge, 2) ?></strong>
                    <br><small>Recharge Added</small>
                </div>
                <div>
                    <strong style="color:#27ae60;">+₹<?= number_format($total_winnings, 2) ?></strong>
                    <br><small>Winnings</small>
                </div>
                <div>
                    <strong style="color:#e74c3c;">-₹<?= number_format($total_bet_amount, 2) ?></strong>
                    <br><small>Bets Placed</small>
                </div>
                <div>
                    <strong style="color:#e74c3c;">-₹<?= number_format($approved_withdrawal, 2) ?></strong>
                    <br><small>Withdrawals</small>
                </div>
                <div style="border-left:2px solid #ffc107;padding-left:15px;">
                    <?php 
                    $net_change = $approved_recharge + $total_winnings - $total_bet_amount - $approved_withdrawal;
                    $net_color = $net_change >= 0 ? '#27ae60' : '#e74c3c';
                    $net_sign = $net_change >= 0 ? '+' : '';
                    ?>
                    <strong style="color:<?= $net_color ?>;font-size:18px;"><?= $net_sign ?>₹<?= number_format($net_change, 2) ?></strong>
                    <br><small>Net Change</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Recharge History -->
    <?php if(!empty($recharge_data)): ?>
    <div class="content-box">
        <h2 class="section-title">💳 Recharge History</h2>
        <table class="table wallet-history-table">
            <thead>
                <tr>
                    <th>Time</th>
                    <th>Amount</th>
                    <th>Method</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($recharge_data as $recharge): ?>
                <tr>
                    <td><?= date('H:i:s', strtotime($recharge['created_at'])) ?></td>
                    <td style="font-weight:700;color:#3498db;">₹<?= number_format($recharge['amount'], 2) ?></td>
                    <td><?= ucfirst($recharge['method']) ?></td>
                    <td>
                        <span class="status <?= $recharge['status'] ?>">
                            <?= ucfirst($recharge['status']) ?>
                        </span>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>

    <!-- Betting History -->
    <?php if(!empty($betting_data)): ?>
    <div class="content-box">
        <h2 class="section-title">🎮 Betting History</h2>
        <table class="table wallet-history-table betting-table">
            <thead>
                <tr>
                    <th>Time</th>
                    <th>Bets Count</th>
                    <th>Total Bet</th>
                    <th>Result</th>
                    <th>Win Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($betting_data as $bet): ?>
                <tr>
                    <td><?= date('H:i:s', strtotime($bet['bet_time'])) ?></td>
                    <td style="font-weight:700;color:#3498db;"><?= $bet['bet_count'] ?> bet(s)</td>
                    <td style="font-weight:700;color:#9b59b6;">₹<?= number_format($bet['total_bet_amount'], 2) ?></td>
                    <td>
                        <?php 
                        $result_status = $bet['total_win_amount'] > 0 ? 'win' : ($bet['game_result'] == 'pending' ? 'pending' : 'loss');
                        ?>
                        <span class="status <?= $result_status ?>">
                            <?= $result_status == 'win' ? 'WIN' : ($result_status == 'loss' ? 'LOSS' : 'PENDING') ?>
                        </span>
                        <?php if($bet['winning_color']): ?>
                            <br><small style="opacity:0.7;">Winner: 
                                <span style="display:inline-block;width:12px;height:12px;border-radius:50%;background:<?= getColorCode($bet['winning_color']) ?>;margin:0 4px;"></span>
                                <?= strtoupper($bet['winning_color']) ?>
                            </small>
                        <?php endif; ?>
                    </td>
                    <td style="font-weight:700;color:<?= $bet['total_win_amount'] > 0 ? '#27ae60' : '#666' ?>;">
                        <?= $bet['total_win_amount'] > 0 ? '₹' . number_format($bet['total_win_amount'], 2) : '-' ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>

    <!-- Withdrawal History -->
    <?php if(!empty($withdrawal_data)): ?>
    <div class="content-box">
        <h2 class="section-title">🏧 Withdrawal History</h2>
        <table class="table wallet-history-table">
            <thead>
                <tr>
                    <th>Time</th>
                    <th>Amount</th>
                    <th>Method</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($withdrawal_data as $withdrawal): ?>
                <tr>
                    <td><?= date('H:i:s', strtotime($withdrawal['created_at'])) ?></td>
                    <td style="font-weight:700;color:#e74c3c;">₹<?= number_format($withdrawal['amount'], 2) ?></td>
                    <td><?= ucfirst(str_replace('_', ' ', $withdrawal['method'])) ?></td>
                    <td>
                        <span class="status <?= $withdrawal['status'] ?>">
                            <?= ucfirst($withdrawal['status']) ?>
                        </span>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>

    <!-- No Data Message -->
    <?php if(empty($recharge_data) && empty($betting_data) && empty($withdrawal_data)): ?>
    <div class="content-box">
        <div class="empty-state">
            <div class="empty-state-icon">📊</div>
            <div class="empty-state-title">No Activity Found</div>
            <div class="empty-state-text">No transactions found for <?= date('M j, Y', strtotime($selected_date)) ?></div>
            <a href="?date=<?= date('Y-m-d') ?>" class="btn" style="margin-top:20px;">📅 View Today's Activity</a>
        </div>
    </div>
    <?php endif; ?>

    <!-- Quick Navigation -->
    <div class="content-box">
        <h2 class="section-title">🚀 Quick Actions</h2>
        <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:15px;">
            <a href="recharge.php" class="card" style="text-decoration:none;color:inherit;display:block;">
                <div style="text-align:center;">
                    <div style="font-size:32px;margin-bottom:10px;">💳</div>
                    <p style="font-weight:600;">Add Money</p>
                </div>
            </a>
            <a href="game.php" class="card" style="text-decoration:none;color:inherit;display:block;">
                <div style="text-align:center;">
                    <div style="font-size:32px;margin-bottom:10px;">🎮</div>
                    <p style="font-weight:600;">Play Game</p>
                </div>
            </a>
            <a href="withdraw.php" class="card" style="text-decoration:none;color:inherit;display:block;">
                <div style="text-align:center;">
                    <div style="font-size:32px;margin-bottom:10px;">🏧</div>
                    <p style="font-weight:600;">Withdraw</p>
                </div>
            </a>
        </div>
    </div>
</div>

<style>
/* Additional styles for wallet history */
.status.approved, .status.completed {
    background: rgba(39, 174, 96, 0.3);
    color: #27ae60;
    border: 1px solid #27ae60;
}

.status.pending {
    background: rgba(255, 193, 7, 0.3);
    color: #ffc107;
    border: 1px solid #ffc107;
}

.status.rejected, .status.failed {
    background: rgba(231, 76, 60, 0.3);
    color: #e74c3c;
    border: 1px solid #e74c3c;
}

.status.win {
    background: rgba(39, 174, 96, 0.3);
    color: #27ae60;
    border: 1px solid #27ae60;
}

.status.loss {
    background: rgba(231, 76, 60, 0.3);
    color: #e74c3c;
    border: 1px solid #e74c3c;
}
</style>

<?php
function getColorCode($color) {
    $colors = [
        'red' => '#ef4444',
        'green' => '#22c55e', 
        'yellow' => '#facc15',
        'blue' => '#3b82f6',
        'purple' => '#a855f7',
        'orange' => '#fb923c',
        'pink' => '#ec4899',
        'cyan' => '#06b6d4'
    ];
    return $colors[strtolower($color)] ?? '#666';
}

include("includes/footer.php"); 
?>