<?php
include("config/db.php");

echo "<h2>🧪 Test Winning Logic</h2>";

// Test color matching
$test_colors = ['red', 'green', 'blue', 'yellow'];
$winner = 'red';

echo "<h3>Color Matching Test</h3>";
foreach($test_colors as $color){
    $match = (strtolower(trim($color)) === strtolower(trim($winner)));
    $result = $match ? "✅ WIN" : "❌ LOSS";
    echo "<p>Color: <span style='background:$color;color:white;padding:2px 8px'>$color</span> vs Winner: <span style='background:$winner;color:white;padding:2px 8px'>$winner</span> = $result</p>";
}

// Test bet calculation
echo "<h3>Bet Calculation Test</h3>";
$test_bets = [
    ['color' => 'red', 'amount' => 100],
    ['color' => 'blue', 'amount' => 50],
    ['color' => 'red', 'amount' => 200]
];

$total_bet = 0;
$total_win = 0;

foreach($test_bets as $bet){
    $total_bet += $bet['amount'];
    if(strtolower($bet['color']) === strtolower($winner)){
        $win = $bet['amount'] * 2;
        $total_win += $win;
        echo "<p>✅ {$bet['color']} ₹{$bet['amount']} → WIN ₹$win</p>";
    } else {
        echo "<p>❌ {$bet['color']} ₹{$bet['amount']} → LOSS ₹0</p>";
    }
}

echo "<hr>";
echo "<p><strong>Total Bet:</strong> ₹$total_bet</p>";
echo "<p><strong>Total Win:</strong> ₹$total_win</p>";
echo "<p><strong>Net Result:</strong> ₹" . ($total_win - $total_bet) . "</p>";

echo "<hr>";
echo "<p><a href='user/dashboard.php'>🎮 Go to Game</a></p>";
echo "<p><a href='debug_bets.php'>🔍 Debug Bets</a></p>";
?>