<?php
// Simple test script to verify mobile responsive design
?>
<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mobile Responsive Test - Color Prediction Game</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: #fff;
        }
        
        .test-container {
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .test-section {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 20px;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .test-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin: 20px 0;
        }
        
        .test-card {
            background: rgba(255, 255, 255, 0.2);
            padding: 15px;
            border-radius: 10px;
            text-align: center;
        }
        
        .test-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        
        .test-table th,
        .test-table td {
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .test-table th {
            background: rgba(255, 255, 255, 0.1);
            font-weight: bold;
        }
        
        .test-button {
            background: linear-gradient(135deg, #ffd700, #ffb700);
            color: #000;
            border: none;
            padding: 12px 20px;
            border-radius: 8px;
            cursor: pointer;
            font-weight: bold;
            margin: 5px;
            transition: all 0.3s ease;
        }
        
        .test-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(255, 215, 0, 0.4);
        }
        
        .test-form {
            display: flex;
            flex-direction: column;
            gap: 15px;
            max-width: 400px;
        }
        
        .test-input {
            padding: 12px;
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 8px;
            background: rgba(255, 255, 255, 0.1);
            color: #fff;
            font-size: 16px;
        }
        
        .test-input::placeholder {
            color: rgba(255, 255, 255, 0.6);
        }
        
        /* Mobile Responsive Styles */
        @media (max-width: 768px) {
            body {
                padding: 10px;
                font-size: 14px;
            }
            
            .test-section {
                padding: 15px;
                margin-bottom: 15px;
            }
            
            .test-grid {
                grid-template-columns: 1fr;
                gap: 10px;
            }
            
            .test-table {
                font-size: 12px;
                overflow-x: auto;
                display: block;
                white-space: nowrap;
            }
            
            .test-table thead, .test-table tbody, .test-table th, .test-table td, .test-table tr {
                display: block;
            }
            
            .test-table thead tr {
                position: absolute;
                top: -9999px;
                left: -9999px;
            }
            
            .test-table tr {
                border: 1px solid rgba(255, 255, 255, 0.2);
                margin-bottom: 10px;
                padding: 10px;
                border-radius: 8px;
                background: rgba(255, 255, 255, 0.05);
                white-space: normal;
            }
            
            .test-table td {
                border: none;
                position: relative;
                padding: 8px 8px 8px 50%;
                text-align: left;
            }
            
            .test-table td:before {
                position: absolute;
                left: 6px;
                width: 45%;
                padding-right: 10px;
                white-space: nowrap;
                font-weight: 600;
                color: #ffd700;
            }
            
            .test-table td:nth-child(1):before { content: "Name: "; }
            .test-table td:nth-child(2):before { content: "Value: "; }
            .test-table td:nth-child(3):before { content: "Status: "; }
            .test-table td:nth-child(4):before { content: "Action: "; }
            
            .test-button {
                width: 100%;
                margin: 5px 0;
                padding: 15px;
                font-size: 14px;
            }
            
            .test-form {
                max-width: 100%;
            }
            
            .test-input {
                font-size: 16px; /* Prevent zoom on iOS */
            }
        }
        
        @media (max-width: 480px) {
            body {
                padding: 5px;
                font-size: 13px;
            }
            
            .test-section {
                padding: 10px;
            }
            
            .test-table {
                font-size: 11px;
            }
            
            .test-table td {
                padding: 6px 6px 6px 45%;
                font-size: 11px;
            }
            
            .test-table td:before {
                font-size: 10px;
            }
            
            .test-button {
                padding: 12px;
                font-size: 13px;
            }
        }
        
        /* Touch improvements */
        @media (max-width: 768px) {
            .test-button, .test-card {
                min-height: 44px;
                touch-action: manipulation;
                -webkit-tap-highlight-color: rgba(255, 255, 255, 0.1);
            }
            
            .test-input {
                min-height: 44px;
            }
        }
    </style>
</head>
<body>
    <div class="test-container">
        <div class="test-section">
            <h1>📱 Mobile Responsive Test</h1>
            <p>This page tests the mobile responsive design for the Color Prediction Game project.</p>
            <p><strong>Screen Width:</strong> <span id="screenWidth"></span>px</p>
            <p><strong>Device Type:</strong> <span id="deviceType"></span></p>
        </div>
        
        <div class="test-section">
            <h2>🎮 Game Elements Test</h2>
            <div class="test-grid">
                <div class="test-card">
                    <h3>🔴 Red</h3>
                    <p>Color Option</p>
                    <button class="test-button">Bet ₹100</button>
                </div>
                <div class="test-card">
                    <h3>🟢 Green</h3>
                    <p>Color Option</p>
                    <button class="test-button">Bet ₹100</button>
                </div>
                <div class="test-card">
                    <h3>🟡 Yellow</h3>
                    <p>Color Option</p>
                    <button class="test-button">Bet ₹100</button>
                </div>
                <div class="test-card">
                    <h3>🔵 Blue</h3>
                    <p>Color Option</p>
                    <button class="test-button">Bet ₹100</button>
                </div>
            </div>
        </div>
        
        <div class="test-section">
            <h2>📊 Table Test</h2>
            <table class="test-table">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Value</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>User Balance</td>
                        <td>₹1,250.00</td>
                        <td>Active</td>
                        <td><button class="test-button">View</button></td>
                    </tr>
                    <tr>
                        <td>Last Game</td>
                        <td>Red Win</td>
                        <td>Completed</td>
                        <td><button class="test-button">Details</button></td>
                    </tr>
                    <tr>
                        <td>Withdrawal</td>
                        <td>₹500.00</td>
                        <td>Pending</td>
                        <td><button class="test-button">Cancel</button></td>
                    </tr>
                </tbody>
            </table>
        </div>
        
        <div class="test-section">
            <h2>📝 Form Test</h2>
            <form class="test-form">
                <input type="text" class="test-input" placeholder="Enter your name">
                <input type="email" class="test-input" placeholder="Enter your email">
                <input type="number" class="test-input" placeholder="Enter bet amount">
                <select class="test-input">
                    <option>Select payment method</option>
                    <option>UPI</option>
                    <option>Bank Transfer</option>
                    <option>Paytm</option>
                </select>
                <button type="button" class="test-button">Submit Form</button>
            </form>
        </div>
        
        <div class="test-section">
            <h2>🔗 Navigation Test</h2>
            <div style="display: flex; flex-wrap: wrap; gap: 10px;">
                <button class="test-button">Dashboard</button>
                <button class="test-button">Play Game</button>
                <button class="test-button">Recharge</button>
                <button class="test-button">Withdraw</button>
                <button class="test-button">History</button>
                <button class="test-button">Profile</button>
            </div>
        </div>
        
        <div class="test-section">
            <h2>✅ Test Results</h2>
            <div id="testResults">
                <p>✅ Viewport meta tag: Present</p>
                <p>✅ Touch-friendly buttons: 44px minimum height</p>
                <p>✅ Responsive tables: Card layout on mobile</p>
                <p>✅ Form inputs: 16px font size (prevents zoom)</p>
                <p>✅ Flexible grid: Adapts to screen size</p>
            </div>
        </div>
    </div>
    
    <script>
        // Update screen information
        function updateScreenInfo() {
            const width = window.innerWidth;
            document.getElementById('screenWidth').textContent = width;
            
            let deviceType = 'Desktop';
            if (width <= 480) {
                deviceType = 'Mobile (Small)';
            } else if (width <= 768) {
                deviceType = 'Mobile/Tablet';
            } else if (width <= 1024) {
                deviceType = 'Tablet/Small Desktop';
            }
            
            document.getElementById('deviceType').textContent = deviceType;
        }
        
        // Update on load and resize
        updateScreenInfo();
        window.addEventListener('resize', updateScreenInfo);
        
        // Test button interactions
        document.querySelectorAll('.test-button').forEach(button => {
            button.addEventListener('click', function() {
                this.style.background = '#28a745';
                this.textContent = '✅ Clicked!';
                setTimeout(() => {
                    this.style.background = 'linear-gradient(135deg, #ffd700, #ffb700)';
                    this.textContent = this.textContent.replace('✅ Clicked!', 'Test Button');
                }, 1000);
            });
        });
    </script>
</body>
</html>