<?php
include("config/db.php");

echo "<h2>⚡ Quick Timing Fix</h2>";

// Delete all existing completed games
mysqli_query($conn, "DELETE FROM games WHERE status='completed'");
echo "<p>✅ Cleared existing results</p>";

// Create 10 new games with proper timing
$colors = ['red', 'green', 'yellow', 'blue', 'purple', 'orange', 'pink', 'cyan'];
$time_intervals = [5, 18, 35, 52, 68, 85, 105, 135, 180, 240]; // minutes ago

echo "<h3>Creating results with proper timing:</h3>";

for($i = 0; $i < 10; $i++) {
    $winner = $colors[array_rand($colors)];
    $minutes_ago = $time_intervals[$i];
    
    $sql = "INSERT INTO games (status, winning_color, created_at, completed_at) 
            VALUES ('completed', '$winner', 
                    NOW() - INTERVAL $minutes_ago MINUTE, 
                    NOW() - INTERVAL $minutes_ago MINUTE)";
    
    $result = mysqli_query($conn, $sql);
    
    if($result) {
        // Calculate display time
        if($minutes_ago < 60) {
            $display = $minutes_ago . "m ago";
        } else {
            $hours = floor($minutes_ago / 60);
            $remaining = $minutes_ago % 60;
            if($remaining > 0) {
                $display = $hours . "h " . $remaining . "m ago";
            } else {
                $display = $hours . "h ago";
            }
        }
        
        echo "✅ Created: <strong>$winner</strong> - $display<br>";
    } else {
        echo "❌ Failed to create $winner<br>";
    }
}

echo "<h3>Verification with Database Calculation:</h3>";

// Test the database calculation
$verify = mysqli_query($conn, "
    SELECT winning_color, completed_at,
           TIMESTAMPDIFF(MINUTE, completed_at, NOW()) as minutes_diff,
           TIMESTAMPDIFF(SECOND, completed_at, NOW()) as seconds_diff
    FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL 
    ORDER BY completed_at DESC 
    LIMIT 10
");

while($row = mysqli_fetch_assoc($verify)) {
    $minutes = (int)$row['minutes_diff'];
    $seconds = (int)$row['seconds_diff'];
    
    if($seconds < 60) {
        $display = 'Just now';
    } else if($minutes < 60) {
        $display = $minutes . 'm ago';
    } else {
        $hours = floor($minutes / 60);
        $remaining = $minutes % 60;
        if($remaining > 0) {
            $display = $hours . 'h ' . $remaining . 'm ago';
        } else {
            $display = $hours . 'h ago';
        }
    }
    
    echo "🎯 <strong>{$row['winning_color']}</strong> - $display (DB: {$minutes}m, {$seconds}s)<br>";
}

echo "<br><strong>✅ Database updated with proper timing!</strong>";
echo "<br><br><a href='user/dashboard.php' target='_blank' style='background:#28a745;color:white;padding:10px 15px;text-decoration:none;border-radius:5px;'>📊 Check Dashboard Now</a>";
?>