<?php
include("config/db.php");

if(!isset($_SESSION['user_id'])){
    die("Please login first");
}

$user_id = $_SESSION['user_id'];

echo "<h2>🚀 Quick Debug</h2>";

// Get current running game
$game = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM games WHERE status='running' ORDER BY id DESC LIMIT 1"));

if($game){
    $game_id = $game['id'];
    echo "<h3>Current Game: #$game_id</h3>";
    
    // Get all bets for this user and game
    $bets = mysqli_query($conn, "SELECT * FROM bets WHERE game_id=$game_id AND user_id=$user_id ORDER BY id DESC");
    $bet_count = mysqli_num_rows($bets);
    
    echo "<p><strong>Your Bets in Current Game:</strong> $bet_count</p>";
    
    if($bet_count > 0){
        echo "<table border='1' style='border-collapse:collapse; width:100%'>";
        echo "<tr><th>ID</th><th>Color</th><th>Amount</th><th>Status</th><th>Win Amount</th><th>Created</th></tr>";
        
        while($bet = mysqli_fetch_assoc($bets)){
            $bg = $bet['status'] == 'win' ? '#d4edda' : ($bet['status'] == 'loss' ? '#f8d7da' : '#fff3cd');
            echo "<tr style='background:$bg'>";
            echo "<td>{$bet['id']}</td>";
            echo "<td style='background:{$bet['color']};color:white;padding:5px'>{$bet['color']}</td>";
            echo "<td>₹{$bet['amount']}</td>";
            echo "<td>{$bet['status']}</td>";
            echo "<td>₹{$bet['win_amount']}</td>";
            echo "<td>{$bet['created_at']}</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // Manual result test
        echo "<h3>🎯 Manual Result Test</h3>";
        echo "<form method='post'>";
        echo "<input type='hidden' name='test_game_id' value='$game_id'>";
        echo "<label>Force Winner:</label>";
        echo "<select name='force_winner'>";
        $colors = ['red','green','yellow','blue','purple','orange','pink','cyan'];
        foreach($colors as $color){
            echo "<option value='$color'>$color</option>";
        }
        echo "</select>";
        echo "<button type='submit' name='manual_test'>Test Result</button>";
        echo "</form>";
        
    } else {
        echo "<p>❌ No bets found in current game</p>";
        echo "<p><strong>Possible Issues:</strong></p>";
        echo "<ul>";
        echo "<li>Bets not being placed properly</li>";
        echo "<li>Game ID mismatch</li>";
        echo "<li>Database connection issue</li>";
        echo "</ul>";
    }
} else {
    echo "<h3>❌ No Running Game Found</h3>";
    echo "<p>Creating new game...</p>";
    mysqli_query($conn, "INSERT INTO games (status, created_at) VALUES ('running', NOW())");
    echo "<p>✅ New game created. <a href=''>Refresh</a></p>";
}

// Manual test processing
if(isset($_POST['manual_test'])){
    $test_game_id = (int)$_POST['test_game_id'];
    $winner = $_POST['force_winner'];
    
    echo "<hr><h3>🧪 Manual Test Result</h3>";
    echo "<p><strong>Game:</strong> #$test_game_id</p>";
    echo "<p><strong>Forced Winner:</strong> $winner</p>";
    
    // Get user's bets
    $test_bets = mysqli_query($conn, "SELECT * FROM bets WHERE game_id=$test_game_id AND user_id=$user_id");
    $total_win = 0;
    $total_bet = 0;
    
    echo "<h4>Processing Bets:</h4>";
    while($bet = mysqli_fetch_assoc($test_bets)){
        $total_bet += $bet['amount'];
        $bet_color = strtolower(trim($bet['color']));
        $winner_color = strtolower(trim($winner));
        $match = ($bet_color === $winner_color);
        
        if($match){
            $win = $bet['amount'] * 2;
            $total_win += $win;
            mysqli_query($conn, "UPDATE users SET wallet = wallet + $win WHERE id = $user_id");
            mysqli_query($conn, "UPDATE bets SET status='win', win_amount=$win WHERE id={$bet['id']}");
            echo "<p>✅ {$bet['color']} ₹{$bet['amount']} → WIN ₹$win</p>";
        } else {
            mysqli_query($conn, "UPDATE bets SET status='loss', win_amount=0 WHERE id={$bet['id']}");
            echo "<p>❌ {$bet['color']} ₹{$bet['amount']} → LOSS</p>";
        }
        
        echo "<p style='font-size:12px; color:#666;'>Debug: '{$bet['color']}' vs '$winner' → '{$bet_color}' vs '{$winner_color}' = " . ($match ? 'MATCH' : 'NO MATCH') . "</p>";
    }
    
    // Update game
    mysqli_query($conn, "UPDATE games SET status='completed', winning_color='$winner' WHERE id=$test_game_id");
    
    // Get updated wallet
    $user = mysqli_fetch_assoc(mysqli_query($conn, "SELECT wallet FROM users WHERE id=$user_id"));
    
    echo "<h4>📊 Final Result:</h4>";
    echo "<p><strong>Total Bet:</strong> ₹$total_bet</p>";
    echo "<p><strong>Total Win:</strong> ₹$total_win</p>";
    echo "<p><strong>Updated Wallet:</strong> ₹{$user['wallet']}</p>";
}

echo "<hr>";
echo "<p><a href='user/dashboard.php'>🎮 Back to Game</a></p>";
?>