<?php
include("config/db.php");

echo "<h2>🕐 Fix Result Timing</h2>";

// Get all completed games
$games = mysqli_query($conn, "
    SELECT id, winning_color, completed_at 
    FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL 
    ORDER BY id DESC
");

$count = 0;
if($games && mysqli_num_rows($games) > 0) {
    echo "<h3>Updating existing games with varied timing:</h3>";
    
    while($game = mysqli_fetch_assoc($games)) {
        $count++;
        $minutes_ago = $count * 12; // 12, 24, 36, 48... minutes ago
        
        // Update the completed_at time
        $update = mysqli_query($conn, "
            UPDATE games 
            SET completed_at = NOW() - INTERVAL $minutes_ago MINUTE 
            WHERE id = {$game['id']}
        ");
        
        if($update) {
            echo "✅ Game {$game['id']}: {$game['winning_color']} → {$minutes_ago}m ago<br>";
        } else {
            echo "❌ Failed to update game {$game['id']}<br>";
        }
    }
} else {
    echo "<p>No completed games found. Creating new test data...</p>";
    
    $colors = ['red', 'green', 'yellow', 'blue', 'purple', 'orange', 'pink', 'cyan'];
    
    for($i = 0; $i < 10; $i++) {
        $winner = $colors[array_rand($colors)];
        $minutes_ago = ($i + 1) * 18; // 18, 36, 54... minutes ago
        
        $result = mysqli_query($conn, "
            INSERT INTO games (status, winning_color, created_at, completed_at) 
            VALUES (
                'completed', 
                '$winner', 
                NOW() - INTERVAL $minutes_ago MINUTE, 
                NOW() - INTERVAL " . ($minutes_ago - 3) . " MINUTE
            )
        ");
        
        if($result) {
            echo "✅ Created: $winner ({$minutes_ago}m ago)<br>";
        }
    }
}

echo "<h3>Current Results with Timing:</h3>";

// Show current results
$current = mysqli_query($conn, "
    SELECT id, winning_color, completed_at,
           TIMESTAMPDIFF(MINUTE, completed_at, NOW()) as minutes_ago
    FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL 
    ORDER BY completed_at DESC 
    LIMIT 10
");

function format_time_ago($minutes) {
    if($minutes < 1) return 'Just now';
    if($minutes < 60) return $minutes . 'm ago';
    if($minutes < 1440) return floor($minutes/60) . 'h ago';
    return floor($minutes/1440) . 'd ago';
}

while($row = mysqli_fetch_assoc($current)) {
    $time_display = format_time_ago($row['minutes_ago']);
    echo "🎯 Game {$row['id']}: <strong>{$row['winning_color']}</strong> - {$time_display} ({$row['completed_at']})<br>";
}

echo "<br><a href='user/dashboard.php'>📊 View Dashboard</a>";
?>