<?php
include("config/db.php");

echo "<h2>🔧 Fixing Negative Balance Issues</h2>";

// Add columns if not exist
mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS recharge_amount DECIMAL(10,2) DEFAULT 0.00");
mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS winning_amount DECIMAL(10,2) DEFAULT 0.00");

// Get all users with negative balances or incorrect calculations
$users = mysqli_query($conn, "SELECT * FROM users WHERE wallet < 0 OR winning_amount < 0 OR recharge_amount < 0");

echo "<h3>Fixing users with negative balances:</h3>";

while($user = mysqli_fetch_assoc($users)) {
    $user_id = $user['id'];
    
    echo "<div style='background:#fff3cd;padding:15px;margin:10px 0;border-radius:8px;border-left:4px solid #ffc107;'>";
    echo "<h4>👤 {$user['name']} (ID: $user_id)</h4>";
    
    echo "<p><strong>Current (Incorrect) Values:</strong></p>";
    echo "<p>💰 Wallet: ₹" . number_format($user['wallet'], 2) . "</p>";
    echo "<p>🎯 Winning Amount: ₹" . number_format($user['winning_amount'], 2) . "</p>";
    echo "<p>💳 Recharge Amount: ₹" . number_format($user['recharge_amount'], 2) . "</p>";
    
    // Calculate correct values from scratch
    
    // 1. Total winnings from bets
    $winnings = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT COALESCE(SUM(win_amount), 0) as total_winnings 
        FROM bets 
        WHERE user_id = $user_id AND status = 'win'
    "));
    $correct_winning_amount = $winnings['total_winnings'];
    
    // 2. Total approved recharges
    $recharges = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT COALESCE(SUM(amount), 0) as total_recharges 
        FROM recharge_requests 
        WHERE user_id = $user_id AND status = 'approved'
    "));
    $correct_recharge_amount = $recharges['total_recharges'];
    
    // 3. Total APPROVED withdrawals (money that should actually be deducted)
    $approved_withdrawals = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT COALESCE(SUM(amount), 0) as approved_withdrawals 
        FROM withdrawal_requests 
        WHERE user_id = $user_id AND status = 'approved'
    "));
    $approved_withdrawal_amount = $approved_withdrawals['approved_withdrawals'];
    
    // 4. Calculate correct balances
    $correct_winning_balance = $correct_winning_amount - $approved_withdrawal_amount;
    $correct_wallet = $correct_recharge_amount + $correct_winning_balance;
    
    // Ensure no negative values
    $correct_winning_balance = max(0, $correct_winning_balance);
    $correct_wallet = max(0, $correct_wallet);
    
    echo "<p><strong>Calculated Correct Values:</strong></p>";
    echo "<p>🎯 Total Winnings: ₹" . number_format($correct_winning_amount, 2) . "</p>";
    echo "<p>💳 Total Recharges: ₹" . number_format($correct_recharge_amount, 2) . "</p>";
    echo "<p>🏧 Approved Withdrawals: ₹" . number_format($approved_withdrawal_amount, 2) . "</p>";
    echo "<p>🎯 Correct Winning Balance: ₹" . number_format($correct_winning_balance, 2) . "</p>";
    echo "<p>💰 Correct Wallet: ₹" . number_format($correct_wallet, 2) . "</p>";
    
    // Update with correct values
    mysqli_query($conn, "
        UPDATE users 
        SET wallet = $correct_wallet,
            winning_amount = $correct_winning_balance,
            recharge_amount = $correct_recharge_amount
        WHERE id = $user_id
    ");
    
    echo "<p style='color:#27ae60;'><strong>✅ Fixed!</strong></p>";
    echo "</div>";
}

// Also fix all users to ensure consistency
echo "<h3>Ensuring all users have consistent data:</h3>";

$all_users = mysqli_query($conn, "SELECT * FROM users");

while($user = mysqli_fetch_assoc($all_users)) {
    $user_id = $user['id'];
    
    // Calculate correct values from scratch
    $winnings = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT COALESCE(SUM(win_amount), 0) as total_winnings 
        FROM bets 
        WHERE user_id = $user_id AND status = 'win'
    "));
    $correct_winning_amount = $winnings['total_winnings'];
    
    $recharges = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT COALESCE(SUM(amount), 0) as total_recharges 
        FROM recharge_requests 
        WHERE user_id = $user_id AND status = 'approved'
    "));
    $correct_recharge_amount = $recharges['total_recharges'];
    
    $approved_withdrawals = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT COALESCE(SUM(amount), 0) as approved_withdrawals 
        FROM withdrawal_requests 
        WHERE user_id = $user_id AND status = 'approved'
    "));
    $approved_withdrawal_amount = $approved_withdrawals['approved_withdrawals'];
    
    $correct_winning_balance = max(0, $correct_winning_amount - $approved_withdrawal_amount);
    $correct_wallet = $correct_recharge_amount + $correct_winning_balance;
    
    // Update user
    mysqli_query($conn, "
        UPDATE users 
        SET wallet = $correct_wallet,
            winning_amount = $correct_winning_balance,
            recharge_amount = $correct_recharge_amount
        WHERE id = $user_id
    ");
    
    echo "<p>✅ Fixed user: {$user['name']} - Wallet: ₹" . number_format($correct_wallet, 2) . "</p>";
}

echo "<br><h3>✅ All negative balances have been fixed!</h3>";

// Show final summary
$summary = mysqli_query($conn, "
    SELECT 
        COUNT(*) as total_users,
        SUM(wallet) as total_wallet,
        SUM(winning_amount) as total_winnings,
        SUM(recharge_amount) as total_recharge,
        COUNT(CASE WHEN wallet < 0 THEN 1 END) as negative_wallets
    FROM users
");

$stats = mysqli_fetch_assoc($summary);

echo "<div style='background:#e8f5e8;padding:20px;border-radius:10px;margin:20px 0;border:2px solid #28a745;'>";
echo "<h3>📊 Final Summary:</h3>";
echo "<p><strong>Total Users:</strong> " . $stats['total_users'] . "</p>";
echo "<p><strong>Users with Negative Balance:</strong> " . $stats['negative_wallets'] . "</p>";
echo "<p><strong>Total Wallet Amount:</strong> ₹" . number_format($stats['total_wallet'], 2) . "</p>";
echo "<p><strong>Total Winning Amount:</strong> ₹" . number_format($stats['total_winnings'], 2) . "</p>";
echo "<p><strong>Total Recharge Amount:</strong> ₹" . number_format($stats['total_recharge'], 2) . "</p>";
echo "</div>";

echo "<div style='background:#d1ecf1;padding:15px;border-radius:8px;border:1px solid #bee5eb;margin:20px 0;'>";
echo "<h4>🔄 New Withdrawal Process:</h4>";
echo "<ul>";
echo "<li>✅ User submits withdrawal request (no money deducted)</li>";
echo "<li>✅ Admin reviews and approves/rejects</li>";
echo "<li>✅ Money is deducted only when admin approves</li>";
echo "<li>✅ No negative balances anymore</li>";
echo "</ul>";
echo "</div>";

echo "<br><a href='user/withdraw.php' target='_blank' style='background:#28a745;color:white;padding:10px 15px;text-decoration:none;border-radius:5px;margin-right:10px;'>🏧 Test Withdrawal</a>";
echo "<a href='admin/withdrawal_requests.php' target='_blank' style='background:#007bff;color:white;padding:10px 15px;text-decoration:none;border-radius:5px;'>👨‍💼 Admin Panel</a>";
?>