<?php
include("config/db.php");

echo "<h2>Database Structure Check</h2>";

// Check if games table exists and has required columns
echo "<h3>Games Table Structure:</h3>";
$result = mysqli_query($conn, "DESCRIBE games");
if($result) {
    echo "<table border='1'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    while($row = mysqli_fetch_assoc($result)) {
        echo "<tr>";
        echo "<td>{$row['Field']}</td>";
        echo "<td>{$row['Type']}</td>";
        echo "<td>{$row['Null']}</td>";
        echo "<td>{$row['Key']}</td>";
        echo "<td>{$row['Default']}</td>";
        echo "<td>{$row['Extra']}</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "❌ Games table not found or error: " . mysqli_error($conn);
}

// Check if winning_color column exists
echo "<h3>Checking winning_color column:</h3>";
$check = mysqli_query($conn, "SHOW COLUMNS FROM games LIKE 'winning_color'");
if(mysqli_num_rows($check) > 0) {
    echo "✅ winning_color column exists<br>";
} else {
    echo "❌ winning_color column missing<br>";
    echo "Adding winning_color column...<br>";
    $add_column = mysqli_query($conn, "ALTER TABLE games ADD COLUMN winning_color VARCHAR(20) NULL AFTER status");
    if($add_column) {
        echo "✅ winning_color column added successfully<br>";
    } else {
        echo "❌ Failed to add winning_color column: " . mysqli_error($conn) . "<br>";
    }
}

// Check if completed_at column exists
echo "<h3>Checking completed_at column:</h3>";
$check2 = mysqli_query($conn, "SHOW COLUMNS FROM games LIKE 'completed_at'");
if(mysqli_num_rows($check2) > 0) {
    echo "✅ completed_at column exists<br>";
} else {
    echo "❌ completed_at column missing<br>";
    echo "Adding completed_at column...<br>";
    $add_column2 = mysqli_query($conn, "ALTER TABLE games ADD COLUMN completed_at TIMESTAMP NULL AFTER winning_color");
    if($add_column2) {
        echo "✅ completed_at column added successfully<br>";
    } else {
        echo "❌ Failed to add completed_at column: " . mysqli_error($conn) . "<br>";
    }
}

echo "<h3>Sample Data:</h3>";
$sample = mysqli_query($conn, "SELECT * FROM games ORDER BY id DESC LIMIT 3");
while($row = mysqli_fetch_assoc($sample)) {
    echo "ID: {$row['id']}, Status: {$row['status']}, Winner: {$row['winning_color']}, Created: {$row['created_at']}, Completed: {$row['completed_at']}<br>";
}
?>