<?php
include("../config/db.php");
include("../config/session_admin.php");


// Agar admin already login hai
if(isset($_SESSION['admin_id'])){
    header("Location: dashboard.php");
    exit;
}

$msg = "";

// Check for timeout or logout message
if(isset($_GET['timeout'])){
    $msg = "<span style='color:orange;'>⏰ Session expired after 15 minutes of inactivity. Please login again.</span>";
}
if(isset($_GET['logout'])){
    $msg = "<span style='color:green;'>✅ Successfully logged out!</span>";
}

if(isset($_POST['login'])){
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $password = mysqli_real_escape_string($conn, $_POST['password']);

    // Debug: Check if admins table exists
    $table_check = mysqli_query($conn, "SHOW TABLES LIKE 'admins'");
    if(mysqli_num_rows($table_check) == 0) {
        $msg = "<span style='color:red;'>❌ Admins table does not exist!</span>";
    } else {
        $query = mysqli_query($conn,
            "SELECT * FROM admins WHERE username='$username' AND password='$password'"
        );

        if(!$query) {
            $msg = "<span style='color:red;'>❌ Database error: " . mysqli_error($conn) . "</span>";
        } elseif(mysqli_num_rows($query) == 1){
            $row = mysqli_fetch_assoc($query);

            $_SESSION['admin_id'] = $row['id'];
            $_SESSION['admin_username'] = $row['username'];
            $_SESSION['LAST_ACTIVITY'] = time();

            // Debug: Check if session is set
            error_log("Admin Login Success: ID=" . $row['id'] . ", Username=" . $row['username']);
            error_log("Session admin_id: " . $_SESSION['admin_id']);

            header("Location: dashboard.php");
            exit;
        } else {
            // Check if username exists
            $user_check = mysqli_query($conn, "SELECT * FROM admins WHERE username='$username'");
            if(mysqli_num_rows($user_check) == 0) {
                $msg = "<span style='color:red;'>❌ Username not found</span>";
            } else {
                $msg = "<span style='color:red;'>❌ Invalid password</span>";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="mobile-responsive.css">
    <title>Admin Login</title>
    <style>
        body{font-family:Arial;background:#222;text-align:center;color:#fff;}
        .box{
            margin-top:120px;
            background:#333;
            padding:30px;
            display:inline-block;
            border-radius:10px;
        }
        input,button{
            margin:10px;
            padding:10px;
            width:250px;
        }
        button{
            background:#28a745;
            color:#fff;
            border:none;
            border-radius:5px;
        }
        .msg{color:#ff6666;}
        a{color:#aaa;}
    </style>
</head>
<body>

<div class="box">
    <h2>👑 Admin Login</h2>

    <form method="post">
        <input type="text" name="username" placeholder="Admin Username" required><br>
        <input type="password" name="password" placeholder="Admin Password" required><br>
        <button name="login">Login</button>
    </form>

    <div class="msg"><?php echo $msg; ?></div>

    <p><a href="../index.php">← Back to Home</a></p>
</div>

</body>
</html>
