<?php
include("../config/db.php");
include("../config/session_admin.php");



$dateQS = isset($_GET['date']) && $_GET['date'] != ""
    ? "?date=".$_GET['date']
    : "";




if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

$history = [];
$mobile = "";
$bet_date = "";
$total_bet = 0;

if(isset($_POST['search'])){
    $mobile = mysqli_real_escape_string($conn, $_POST['mobile']);
    $bet_date = mysqli_real_escape_string($conn, $_POST['bet_date']);

    // Debug info
    echo "<p style='color:blue;'>🔍 Searching for Mobile: <b>$mobile</b> on Date: <b>$bet_date</b></p>";

    // 1️⃣ user find by mobile (stored in email column)
    $u = mysqli_query($conn,"
        SELECT id 
        FROM users 
        WHERE email='$mobile'
    ");
    $user = mysqli_fetch_assoc($u);

    if($user){
        $uid = $user['id'];
        echo "<p style='color:green;'>✅ User found! ID: <b>$uid</b></p>";

        // 2️⃣ bet history (date-wise filter) with game details
        $q = mysqli_query($conn,"
            SELECT b.color, b.amount, b.status, b.win_amount, b.created_at, 
                   g.winning_color, g.id as game_id
            FROM bets b
            LEFT JOIN games g ON b.game_id = g.id
            WHERE b.user_id=$uid
            AND DATE(b.created_at)='$bet_date'
            ORDER BY b.created_at DESC
        ");

        $total_records = mysqli_num_rows($q);
        echo "<p style='color:blue;'>📊 Total bet records found: <b>$total_records</b></p>";

        while($row = mysqli_fetch_assoc($q)){
            $history[] = $row;
            $total_bet += (int)$row['amount'];
        }
    } else {
        $error_msg = "No user found with mobile number: $mobile";
        
        // Show sample users for reference
        $sample_users = mysqli_query($conn, "SELECT id, email FROM users LIMIT 5");
        echo "<p style='color:orange;'>📋 Sample users in database:</p><ul>";
        while($sample = mysqli_fetch_assoc($sample_users)){
            echo "<li>ID: {$sample['id']}, Mobile: {$sample['email']}</li>";
        }
        echo "</ul>";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="mobile-responsive.css">
<title>User Bet History</title>
<style>
body{font-family:Arial;background:#f4f6f8}
.box{
    width:900px;
    background:#fff;
    padding:20px;
    margin:30px auto;
    border-radius:8px;
    box-shadow:0 2px 6px rgba(0,0,0,.2);
}
input,button{
    padding:8px;
}
table{
    width:100%;
    border-collapse:collapse;
    margin-top:15px;
}
table th, table td{
    border:1px solid #ccc;
    padding:8px;
    text-align:center;
}
th{background:#eee}
.total{
    margin-top:15px;
    font-size:18px;
    font-weight:bold;
    text-align:right;
}
.back{margin-top:10px;display:inline-block}
</style>
</head>
<body>

<div class="box">
    <h2>🎮 User Bet / Game History (Mobile Search)</h2>

    <!-- 🔍 SEARCH FORM -->
    <form method="post">
        <label>User Mobile Number :</label>
        <input type="text" name="mobile" required placeholder="Enter mobile number" maxlength="15">

        <label>Date :</label>
        <input type="date" name="bet_date" required>

        <button type="submit" name="search">Search</button>
    </form>

    <?php if(isset($error_msg)){ ?>
        <p style="color:red;"><b><?php echo $error_msg; ?></b></p>
    <?php } ?>

    <?php if(isset($_POST['search'])){ ?>

        <?php if(empty($history)){ ?>
            <p><b>No bet history found for this date.</b></p>
        <?php }else{ ?>

        <table class="bet-history-table">
            <tr>
                <th>#</th>
                <th>Game ID</th>
                <th>Bet Color</th>
                <th>Bet Amount</th>
                <th>Result Color</th>
                <th>Status</th>
                <th>Win Amount</th>
                <th>Date & Time</th>
            </tr>

            <?php $i=1; $total_win = 0; foreach($history as $h){ 
                $total_win += (float)$h['win_amount'];
            ?>
            <tr>
                <td><?php echo $i++; ?></td>
                <td style="font-family:monospace;">#<?php echo $h['game_id'] ?? 'N/A'; ?></td>
                <td>
                    <span style="padding:4px 8px;border-radius:4px;color:white;background:<?php 
                        $color = strtolower($h['color']);
                        echo ($color == 'red') ? '#e74c3c' : 
                             (($color == 'green') ? '#27ae60' : 
                             (($color == 'blue') ? '#3498db' : 
                             (($color == 'yellow') ? '#f39c12' : '#9b59b6')));
                    ?>;">
                        <?php echo ucfirst($h['color']); ?>
                    </span>
                </td>
                <td style="font-weight:bold;color:#e74c3c;">₹<?php echo number_format($h['amount'], 2); ?></td>
                <td>
                    <?php if($h['winning_color']): ?>
                        <span style="padding:4px 8px;border-radius:4px;color:white;background:<?php 
                            $win_color = strtolower($h['winning_color']);
                            echo ($win_color == 'red') ? '#e74c3c' : 
                                 (($win_color == 'green') ? '#27ae60' : 
                                 (($win_color == 'blue') ? '#3498db' : 
                                 (($win_color == 'yellow') ? '#f39c12' : '#9b59b6')));
                        ?>;">
                            <?php echo ucfirst($h['winning_color']); ?>
                        </span>
                    <?php else: ?>
                        <span style="color:#999;">Pending</span>
                    <?php endif; ?>
                </td>
                <td>
                    <?php 
                    $status = $h['status'];
                    $status_color = '';
                    if($status == 'win') $status_color = 'color:#27ae60;font-weight:bold;';
                    elseif($status == 'loss') $status_color = 'color:#e74c3c;font-weight:bold;';
                    else $status_color = 'color:#f39c12;font-weight:bold;';
                    echo "<span style='$status_color'>" . ucfirst($status) . "</span>";
                    ?>
                </td>
                <td style="font-weight:bold;color:#27ae60;">
                    <?php echo ($h['win_amount'] > 0) ? '₹' . number_format($h['win_amount'], 2) : '-'; ?>
                </td>
                <td><?php echo date("d-m-Y h:i A", strtotime($h['created_at'])); ?></td>
            </tr>
            <?php } ?>

        </table>

        <!-- ✅ SUMMARY -->
        <div style="margin-top:20px;padding:15px;background:#f8f9fa;border-radius:8px;">
            <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:15px;">
                <div>
                    <strong>📅 Date:</strong> <?php echo date("d-m-Y", strtotime($bet_date)); ?>
                </div>
                <div>
                    <strong>📱 Mobile:</strong> <?php echo $mobile; ?>
                </div>
                <div>
                    <strong>🎯 Total Bets:</strong> <?php echo count($history); ?>
                </div>
                <div>
                    <strong>💰 Total Bet Amount:</strong> ₹<?php echo number_format($total_bet, 2); ?>
                </div>
                <div>
                    <strong>🏆 Total Win Amount:</strong> ₹<?php echo number_format($total_win, 2); ?>
                </div>
                <div>
                    <strong>📊 Net Result:</strong> 
                    <span style="color:<?php echo ($total_win > $total_bet) ? '#27ae60' : '#e74c3c'; ?>;font-weight:bold;">
                        ₹<?php echo number_format($total_win - $total_bet, 2); ?>
                        <?php echo ($total_win > $total_bet) ? '(Profit)' : '(Loss)'; ?>
                    </span>
                </div>
            </div>
        </div>

        <?php } ?>
    <?php } ?>

    <!-- <a class="back" href="dashboard.php">⬅ Back to Dashboard</a> -->


    <a href="dashboard.php<?php echo $dateQS; ?>">
⬅ Back to Dashboard
</a>

</div>

</body>
</html>
