<?php
include("../config/db.php");
include("../config/session_admin.php");


if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

$dateQS = isset($_GET['date']) && $_GET['date'] != ""
    ? "?date=".$_GET['date']
    : "";

$msg = "";
$user_found = null;

// Add recharge_amount column if not exists
mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS recharge_amount DECIMAL(10,2) DEFAULT 0.00");

/* ================= USER SEARCH ================= */
if(isset($_POST['search_user'])){
    $search_mobile = mysqli_real_escape_string($conn, $_POST['search_mobile']);
    
    // Validate mobile number (10 digits)
    if(!preg_match('/^[0-9]{10}$/', $search_mobile)){
        $msg = "❌ Please enter a valid 10-digit mobile number";
    } else {
        // Search user by mobile number (stored in email column)
        $search_result = mysqli_query($conn,"
            SELECT id, name, email, wallet, 
                   COALESCE(recharge_amount, 0) as recharge_amount,
                   COALESCE(winning_amount, 0) as winning_amount,
                   created_at
            FROM users 
            WHERE email='$search_mobile'
        ");

        if($search_result && mysqli_num_rows($search_result) > 0){
            $user_found = mysqli_fetch_assoc($search_result);
            $msg = "✅ User found successfully";
        } else {
            $msg = "❌ No user found with this mobile number";
        }
    }
}

/* ================= ADMIN RECHARGE ================= */
if(isset($_POST['admin_recharge'])){
    $user_id = (int)$_POST['user_id'];
    $amount = (float)$_POST['amount'];
    $note = mysqli_real_escape_string($conn, $_POST['note']);

    if($amount <= 0){
        $msg = "❌ Invalid amount";
    } else {
        // Verify user exists
        $user_check = mysqli_query($conn,"SELECT * FROM users WHERE id=$user_id");
        
        if($user_check && mysqli_num_rows($user_check) > 0){
            // Add to both wallet and recharge_amount
            $update_wallet = mysqli_query($conn,"
                UPDATE users 
                SET wallet = wallet + $amount,
                    recharge_amount = recharge_amount + $amount
                WHERE id = $user_id
            ");

            if($update_wallet) {
                // Record the admin recharge
                mysqli_query($conn,"
                    INSERT INTO recharge_requests (user_id, amount, method, status, created_at, admin_note) 
                    VALUES ($user_id, $amount, 'admin_recharge', 'approved', NOW(), '$note')
                ");

                $msg = "✅ Recharge successful! ₹$amount added to user wallet";
                
                // Refresh user data to show updated balance
                $refresh_result = mysqli_query($conn,"
                    SELECT id, name, email, wallet, 
                           COALESCE(recharge_amount, 0) as recharge_amount,
                           COALESCE(winning_amount, 0) as winning_amount,
                           created_at
                    FROM users 
                    WHERE id=$user_id
                ");
                
                if($refresh_result) {
                    $user_found = mysqli_fetch_assoc($refresh_result);
                }
            } else {
                $msg = "❌ Failed to update user wallet";
            }
        } else {
            $msg = "❌ User not found";
        }
    }
}

// Add admin_note column to recharge_requests if not exists
mysqli_query($conn, "ALTER TABLE recharge_requests ADD COLUMN IF NOT EXISTS admin_note TEXT");
?>
<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="mobile-responsive.css">
<title>Admin Recharge</title>
<style>
body{
    font-family:Arial;
    background:#f4f6f8;
    margin:0;
    padding:20px;
}
.container{
    max-width:800px;
    margin:0 auto;
}
.box{
    background:#fff;
    padding:25px;
    border-radius:10px;
    box-shadow:0 2px 10px rgba(0,0,0,.1);
    margin-bottom:25px;
}
.box h2{
    margin-top:0;
    color:#333;
    border-bottom:2px solid #007bff;
    padding-bottom:10px;
}
.form-group{
    margin-bottom:20px;
}
.form-label{
    display:block;
    margin-bottom:8px;
    font-weight:600;
    color:#333;
}
.form-input{
    width:100%;
    padding:12px;
    border:1px solid #ddd;
    border-radius:8px;
    font-size:14px;
    box-sizing:border-box;
}
.form-input:focus{
    outline:none;
    border-color:#007bff;
    box-shadow:0 0 0 3px rgba(0,123,255,.1);
}
.btn{
    padding:12px 20px;
    border:none;
    border-radius:6px;
    cursor:pointer;
    font-weight:600;
    text-decoration:none;
    display:inline-block;
    margin-right:10px;
}
.btn-primary{background:#007bff;color:#fff}
.btn-success{background:#28a745;color:#fff}
.btn-secondary{background:#6c757d;color:#fff}
.btn:hover{opacity:0.9;transform:translateY(-1px)}
.alert{
    padding:15px;
    border-radius:8px;
    margin-bottom:20px;
    font-weight:600;
}
.alert-success{background:#d4edda;color:#155724;border:1px solid #c3e6cb}
.alert-error{background:#f8d7da;color:#721c24;border:1px solid #f5c6cb}
.user-card{
    background:#f8f9fa;
    border:1px solid #dee2e6;
    border-radius:10px;
    padding:20px;
    margin:20px 0;
}
.user-info{
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(200px,1fr));
    gap:15px;
    margin-bottom:20px;
}
.info-item{
    background:#fff;
    padding:15px;
    border-radius:8px;
    border-left:4px solid #007bff;
}
.info-label{
    font-size:12px;
    color:#666;
    text-transform:uppercase;
    margin-bottom:5px;
}
.info-value{
    font-size:18px;
    font-weight:700;
    color:#333;
}
.back-link{
    color:#007bff;
    text-decoration:none;
    font-weight:600;
}
.back-link:hover{text-decoration:underline}
</style>
</head>
<body>

<div class="container">
    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:30px;">
        <h1>💳 Admin Recharge System</h1>
        <a href="dashboard.php<?php echo $dateQS; ?>" class="back-link">⬅ Back to Dashboard</a>
    </div>

    <?php if($msg): ?>
        <div class="alert <?= strpos($msg, '✅') !== false ? 'alert-success' : 'alert-error' ?>">
            <?= $msg ?>
        </div>
    <?php endif; ?>

    <!-- User Search -->
    <div class="box">
        <h2>🔍 Search User</h2>
        
        <form method="POST">
            <div class="form-group">
                <label class="form-label">User Mobile Number</label>
                <input type="tel" name="search_mobile" class="form-input" 
                       placeholder="Enter user mobile number to search (10 digits)" 
                       pattern="[0-9]{10}" maxlength="10"
                       value="<?= isset($_POST['search_mobile']) ? htmlspecialchars($_POST['search_mobile']) : '' ?>" 
                       required>
            </div>
            
            <button type="submit" name="search_user" class="btn btn-primary">🔍 Search User</button>
        </form>
    </div>

    <!-- User Details (if found) -->
    <?php if($user_found): ?>
    <div class="box">
        <h2>👤 User Details</h2>
        
        <div class="user-card">
            <div class="user-info">
                <div class="info-item">
                    <div class="info-label">User ID</div>
                    <div class="info-value">#<?= $user_found['id'] ?></div>
                </div>
                
                <div class="info-item">
                    <div class="info-label">Name</div>
                    <div class="info-value"><?= htmlspecialchars($user_found['name']) ?></div>
                </div>
                
                <div class="info-item">
                    <div class="info-label">Mobile Number</div>
                    <div class="info-value"><?= htmlspecialchars($user_found['email']) ?></div>
                </div>
                
                <div class="info-item" style="border-left-color:#28a745;">
                    <div class="info-label">Total Wallet</div>
                    <div class="info-value" style="color:#28a745;">₹<?= number_format($user_found['wallet'], 2) ?></div>
                </div>
                
                <div class="info-item" style="border-left-color:#17a2b8;">
                    <div class="info-label">Recharge Amount</div>
                    <div class="info-value" style="color:#17a2b8;">₹<?= number_format($user_found['recharge_amount'], 2) ?></div>
                </div>
                
                <div class="info-item" style="border-left-color:#ffc107;">
                    <div class="info-label">Winning Amount</div>
                    <div class="info-value" style="color:#ffc107;">₹<?= number_format($user_found['winning_amount'], 2) ?></div>
                </div>
                
                <div class="info-item" style="border-left-color:#6c757d;">
                    <div class="info-label">Member Since</div>
                    <div class="info-value" style="color:#6c757d;"><?= date('M j, Y', strtotime($user_found['created_at'])) ?></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Admin Recharge Form -->
    <div class="box">
        <h2>💰 Add Money to User Wallet</h2>
        
        <form method="POST">
            <input type="hidden" name="user_id" value="<?= $user_found['id'] ?>">
            
            <div class="form-group">
                <label class="form-label">Recharge Amount</label>
                <input type="number" name="amount" class="form-input" 
                       placeholder="Enter amount to add" 
                       min="1" step="0.01" required>
            </div>
            
            <div class="form-group">
                <label class="form-label">Admin Note (Optional)</label>
                <textarea name="note" class="form-input" rows="3" 
                          placeholder="Add a note for this recharge (e.g., reason, reference, etc.)"></textarea>
            </div>
            
            <div style="background:#fff3cd;padding:15px;border-radius:8px;border:1px solid #ffeaa7;margin-bottom:20px;">
                <h4 style="color:#856404;margin:0 0 10px;">⚠️ Recharge Summary:</h4>
                <p style="margin:0;color:#856404;">
                    <strong>User:</strong> <?= htmlspecialchars($user_found['name']) ?> (<?= htmlspecialchars($user_found['email']) ?>)<br>
                    <strong>Current Balance:</strong> ₹<?= number_format($user_found['wallet'], 2) ?><br>
                    <strong>Action:</strong> Add money to both total wallet and recharge amount
                </p>
            </div>
            
            <button type="submit" name="admin_recharge" class="btn btn-success">💰 Add Money to Wallet</button>
            <button type="button" onclick="window.location.reload()" class="btn btn-secondary">🔄 Reset</button>
        </form>
    </div>
    <?php endif; ?>

    <!-- Recent Admin Recharges -->
    <div class="box">
        <h2>📋 Recent Admin Recharges</h2>
        
        <?php
        $recent_recharges = mysqli_query($conn, "
            SELECT r.*, u.name, u.email 
            FROM recharge_requests r
            JOIN users u ON u.id = r.user_id
            WHERE r.method = 'admin_recharge' 
            ORDER BY r.created_at DESC 
            LIMIT 10
        ");
        
        if($recent_recharges && mysqli_num_rows($recent_recharges) > 0):
        ?>
            <table style="width:100%;border-collapse:collapse;margin-top:15px;">
                <thead>
                    <tr style="background:#f8f9fa;">
                        <th style="padding:12px;text-align:left;border-bottom:1px solid #ddd;">Date</th>
                        <th style="padding:12px;text-align:left;border-bottom:1px solid #ddd;">User</th>
                        <th style="padding:12px;text-align:left;border-bottom:1px solid #ddd;">Amount</th>
                        <th style="padding:12px;text-align:left;border-bottom:1px solid #ddd;">Note</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($recharge = mysqli_fetch_assoc($recent_recharges)): ?>
                        <tr>
                            <td style="padding:12px;border-bottom:1px solid #eee;">
                                <?= date('M j, Y H:i', strtotime($recharge['created_at'])) ?>
                            </td>
                            <td style="padding:12px;border-bottom:1px solid #eee;">
                                <strong><?= htmlspecialchars($recharge['name']) ?></strong><br>
                                <small style="color:#666;"><?= htmlspecialchars($recharge['email']) ?></small>
                            </td>
                            <td style="padding:12px;border-bottom:1px solid #eee;">
                                <strong style="color:#28a745;">₹<?= number_format($recharge['amount'], 2) ?></strong>
                            </td>
                            <td style="padding:12px;border-bottom:1px solid #eee;">
                                <?= $recharge['admin_note'] ? htmlspecialchars($recharge['admin_note']) : '-' ?>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div style="text-align:center;padding:40px;color:#666;">
                <h3>💳 No Admin Recharges Yet</h3>
                <p>Recent admin recharges will appear here.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

</body>
</html>
